require "prefabutil"
local assets=
{
	Asset("ANIM", "anim/gravi.zip"),
	Asset("IMAGE", "images/inventoryimages/gravi.tex"),
	Asset("ATLAS", "images/inventoryimages/gravi.xml"),
}

local function itemtest(inst, item, slot)
	if not ( item:HasTag("backpack")) then
			return true
end
end

local slotpos = {}

for y = 0, 5 do
	table.insert(slotpos, Vector3(-162, -y*75 + 170 ,0))
	table.insert(slotpos, Vector3(-162 +75, -y*75 + 170 ,0))
end

local function onequip(inst, owner) 
	--owner.AnimState:OverrideSymbol("swap_body", "swap_backpack", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "gravi", "swap_body")
	owner.components.inventory:SetOverflow(inst)
    inst.components.container:Open(owner)
end

local function onunequip(inst, owner) 
--owner.AnimState:ClearOverrideSymbol("backpack")
    owner.AnimState:ClearOverrideSymbol("swap_body")
	 owner.AnimState:ClearOverrideSymbol("backpack")
    owner.components.inventory:SetOverflow(nil)
    inst.components.container:Close(owner)
end

local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("gravi")
    inst.AnimState:SetBuild("gravi")
    inst.AnimState:PlayAnimation("idle", false)
	inst:AddTag("backpack")
		
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.cangoincontainer = true
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/backpack"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gravi.xml"
    
	inst:AddComponent("inspectable")
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
		
	inst:AddComponent("container")
	    inst.components.container.itemtestfn = itemtest
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_piggyback_2x6"
    inst.components.container.widgetanimbuild = "ui_piggyback_2x6"
	inst.components.container.widgetpos = Vector3(-5,-70,0)
	inst.components.container.type = "pack"
	
	inst.components.container.side_widget = true  
	
	if IsDLCEnabled(0002) then
	MakeInventoryFloatable(inst, "anim", "anim")
	end
	
    return inst
end

return Prefab( "common/inventory/gravi", fnab, assets) 